<?php include('header.php');?>
<link rel="stylesheet" href="./css/biographies.css" />
    <section class="welcome">
      <div class="container">
        <div class="row team">
          <div class="col-12 col-sm-12 col-md-12 col-lg-4">
            <h2>Visionary Team!</h2>
            <span class="circle-chevron-right"><img src="./images/icon-arrow-right-color.png"></span>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-8">
            <div class="row">
              <div class="col-12 col-sm-12 col-md-12 col-lg-3 text-center">
                <a href="biografies-linda-timme" class="btn-team active">
                  <div>+</div>
                  <img src="./images/team-person-1.png" class="img-fluid" />
                  <h5>Dr. Linda Timme</h5>
                </a>
              </div>
              <div class="col-12 col-sm-12 col-md-12 col-lg-3 text-center">
                <a href="biografies-david-timme.html" class="btn-team">
                  <div>+</div>
                  <img src="./images/team-person-2.png" class="img-fluid" />
                  <h5>David Timme</h5>
                </a>
              </div>
              <div class="col-12 col-sm-12 col-md-12 col-lg-3 text-center">
                <a href="biografies-robin-vaneerden.html" class="btn-team">
                  <div>+</div>
                  <img src="./images/team-person-3.png" class="img-fluid" />
                  <h5>Robin VanEerden</h5>
                </a>
              </div>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-6 text-start">
            <img src="./images/mentor-image-1.jpg" class="img-fluid" alt="" />
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <h2 class="pb-0">Dr. Linda Timme</h2>
            <h3>
              DSW, MSW, LCSW, LCSW-C, Licensed Psychologist<br>
              Founder and Clinical Director
            </h3>
            <p class="mb-4">
              Dr. Linda is a highly respected psychotherapist, educator, and
              global wellness advocate, with over 15 years of extensive
              experience. She has received numerous accolades for her unwavering
              commitment to behavioral health, trauma recovery, crisis
              intervention, and professional development. As a bilingual
              professional, she is fluent in English and Spanish. Her approach
              involves kindness, honesty, integrity, and a positive outlook. Dr.
              Linda's work ignites hope, uplifts communities, and empowers
              individuals to forge a brighter, more equitable future.
            </p>
            <p>
              Dr. Linda grew up overseas, an experience that shaped her global perspective and fostered a deep appreciation for diverse cultures. Immersed in different ways of life, she developed a profound understanding of human resilience and the interconnectedness of healing. This journey ignited her passion for trauma-informed care, motivating her to go beyond traditional approaches and create transformative spaces for growth. Committed to holistic wellness and evidence-based practices, she empowers professionals to lead with compassion, break barriers, and make a lasting impact.
            </p>      
          </div>
        </div>
      </div>
    </section>
    <section class="renew">
      <div class="container">
        <div class="row">
          <div class="col-12 block-cards btn-container">
            <card class="tab-btn active" data-id="1">
              <div class="text">
                <h3>Professional Journey</h3>
                <a href="javascript:void(0)" class="button is-fifty"
                  ><div>+</div></a
                >
              </div>
            </card>
            <card class="tab-btn" data-id="2">
              <div class="text">
                <h3>
                  Innovative Specializations: Tailored Services for Every Need
                </h3>
                <a href="javascript:void(0)" class="button is-fifty"
                  ><div>+</div></a
                >
              </div>
            </card>
            <card class="tab-btn" data-id="3">
              <div class="text">
                <h3>EMDR Therapy and Consultation Services</h3>
                <a href="javascript:void(0)" class="button is-fifty"
                  ><div>+</div></a
                >
              </div>
            </card>
            <card class="tab-btn" data-id="4">
              <div class="text">
                <h3>Psychotherapy, Evaluations, and Intensive Programs</h3>
                <a href="javascript:void(0)" class="button is-fifty"
                  ><div>+</div></a
                >
              </div>
            </card>
            <card class="tab-btn" data-id="5">
              <div class="text">
                <h3>Career Development and Professional Excellence</h3>
                <a href="javascript:void(0)" class="button is-fifty"
                  ><div>+</div></a
                >
              </div>
            </card>
            <card class="tab-btn" data-id="6">
              <div class="text">
                <h3>Rooted in Balance, Inspired by Connection</h3>
                <a href="javascript:void(0)" class="button is-fifty"
                  ><div>+</div></a
                >
              </div>
            </card>
          </div>
        </div>
        <div class="row mt-5">
          <div class="col-12 block-detail">
            <div class="row my-5">
              <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                <div class="text">
                  <h2>Dr. Linda Timme</h2>
                  <h3>Professional</h3>
                  <h4>Journey</h4>
                  <hr />
                  <img src="./images/emdria-1.png" class="img-fluid" />
                  <img src="./images/emdria-2.png" class="img-fluid" />
                </div>
              </div>
              <div class="col-12 col-sm-12 col-md-12 col-lg-6 about-content">
                <div class="content active" id="1">
                  <p>
                    Dr. Linda launched her career as a licensed psychologist in
                    Peru, dedicating herself to the Latinx and BIPOC/AAPI
                    populations. Upon relocating to the United States, she
                    earned her Clinical Social Work license across multiple
                    states. With a Doctorate in Social Work (DSW) specializing
                    in Leadership and Education, Dr. Linda is known for bringing
                    innovative strategies, strong leadership, and rigorous
                    research into her practice. She has delivered impactful
                    professional training programs across the U.S., Canada, and
                    Latin America.
                  </p>
                  <p>
                    In her role as a licensed Mental Health Practitioner, Dr.
                    Linda brings clinical experience across diverse settings,
                    including psychiatric facilities, mental health centers,
                    nursing homes, assisted living communities, substance abuse
                    treatment facilities, and private practices. Her role also
                    extends to pivotal contributions to community outreach,
                    healthcare administration, and social services. As a
                    passionate advocate for Inclusion, Diversity, Equity, and
                    Access (IDEA) principles, she fosters equitable and
                    inclusive practices in all work areas.
                  </p>
                </div>
                <div class="content" id="2">
                  <p>
                    <strong>Training, Retreats, and Coaching Programs</strong>
                  </p>
                  <p>
                    Dr. Linda is at the forefront of leading national and
                    international events, including wellness retreats, training
                    & workshop sessions, team-building activities, and group
                    projects. Moreover, Dr. Linda provides life and executive
                    coaching services. Her events provide Continuing Education
                    (CE) credits or certifications, focusing on professional
                    development, psychological care, evidence-based therapeutic
                    approaches, clinical resources, self-care, and other topics.
                    With popular destinations across the U.S. and abroad, her
                    services are designed to deliver transformational healing,
                    foster resilience, and empower individuals to achieve their
                    goals and cultivate positive mindsets, leading to more
                    fulfilling and purposeful lives.
                  </p>
                </div>
                <div class="content" id="3">
                  <p>
                    Dr. Linda spearheads a private practice specializing in EMDR
                    (Eye Movement Desensitization and Reprocessing), a highly
                    effective, well-researched, and evidence-based therapeutic
                    approach. She employs advanced protocols such as EMDR-IGTP,
                    EMDR-PRECI, and ASSYST, along with the effective integration
                    of multiple modalities. Dr. Linda enhances treatment
                    outcomes and addresses her clients' memories, emotional
                    pain, and unique needs.
                  </p>
                  <p>
                    As an EMDRIA Advanced Credit Provider and Assisting Faculty
                    for Practicum, Dr. Linda co-facilitates EMDR Basic Training
                    with various organizations and foundations. She is an
                    EMDRIA-certified therapist and Approved Consultant, Dr.
                    Linda provides advanced training and consultation for
                    clinicians seeking certification or aiming to elevate their
                    EMDR proficiency across diverse clinical settings.
                    Additionally, her influential research on EMDR and
                    telehealth continues to advance the field, empowering trauma
                    survivors and upholding high clinical standards.
                  </p>
                </div>
                <div class="content" id="4">
                  <p>
                    Dr. Linda offers comprehensive therapy for individuals,
                    couples, families, and groups, tackling a variety of
                    concerns, such as PTSD, trauma, ASD, vicarious trauma,
                    burnout, grief, anxiety, depression, addictions, chronic
                    pain, and neurodivergent challenges. She expertly integrates
                    traditional and holistic methods, employing EMDR, CBT, DBT,
                    ACT, MI, IFS, and Neuroscience alongside wellness practices
                    such as nature-based interventions, LENS Neurofeedback,
                    expressive arts, surf and ocean therapy, sand-tray therapy,
                    and equine-assisted therapy. She embraces more
                    purpose-driven, fulfilling lives by utilizing breathwork,
                    sound and energy healing, and other alternative practices.
                  </p>
                  <p>
                    Dr. Linda specializes in couples and family therapy, helps
                    rebuild trust, promotes connections, manages disloyalty, and
                    enhances communication. She adeptly addresses family
                    relational challenges and dynamics. She integrates
                    evidence-based methods such as EMDR, Gottman Method,
                    Emotionally Focused Couples Therapy, Structural Family, and
                    other approaches.
                  </p>
                  <p>
                    Dr. Linda conducts trauma and immigration evaluations. She
                    committed to addressing disenfranchised grief and focusing
                    on immigration-related issues for diverse populations. Dr.
                    Linda delivers transformative care that empowers individuals
                    to achieve success. Dr. Linda also facilitates intensive and
                    marathon therapy with interventions tailored to support
                    diverse populations, ensuring comprehensive and culturally
                    responsive care delivery.
                  </p>
                </div>
                <div class="content" id="5">
                  <p>
                    Dr. Linda possesses extensive teaching experience across the
                    curriculum, where she seamlessly blends theory with
                    practical application. She also provides professional
                    consultations for dissertation and thesis success across
                    doctoral, master’s, and bachelor’s programs, empowering
                    individuals to excel academically and overcome test anxiety.
                    By fostering a comprehensive learning environment, she
                    equips students and professionals with the skills necessary
                    to thrive in their respective fields.
                  </p>
                </div>
                <div class="content" id="6">
                  <p>
                    Dr. Linda finds joy and balance in activities that nurture
                    her mind, body, and spirit. Whether surfing, paddleboarding,
                    kayaking, rafting, or trekking, she thrives in the great
                    outdoors and cherishes connecting with horses and other
                    animals. Her practice of energy healing, meditation, and
                    yoga deepens her sense of resilience and well-being, while
                    her passion for creative arts and music fuels her
                    inspiration. Dr. Linda also values the meaningful lessons
                    she learns from her community and family, drawing motivation
                    from her two nieces in medical school and the growth and
                    achievements of her youngest niece and wise siblings.
                    Together, these pursuits and connections form a rich
                    tapestry that supports her vibrant and purposeful life.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="welcome mt-0 pt-4">
      <div class="container">
 
          <div class="row">
            <div class="col-12">
          
              <h2 class="text-center mt-0 title mb-3">Credentials and Achievements</h2>
        
              <h4 class="skyblue">Academic Qualifications</h4>
              <ul>
                <li><strong>Doctor of Social Work (DSW)</strong> – Leadership & Education, Millersville University</li>
                <li><strong>Master of Social Work (MSW)</strong> – Clinical Practice with Individuals and Families, Temple University</li>
              </ul>

<h4 class="skyblue mt-5">Professional Licenses and Certifications</h4>
<ul>
  <li><strong>Licensed Certified Social Worker-Clinical (LCSW-C)</strong> – Maryland</li>
  <li><strong>Licensed Clinical Social Worker (LCSW)</strong> – Pennsylvania & Virginia</li>
  <li><strong>Licensed Psychologist</strong>, clinical and organizational psychologist, University Federico Villarreal, Lima, Peru</li>
  <li>EMDR (Eye Movement Desensitization and Reprocessing) EMDR I and EMDR II, EMDR of Greater Washington, DC, 2017). I and EMDR 2, Washington, DC</li>
  <li>EMDR Certified Therapist by the EMDR International Association (EMDRIA)</li>
  <li>EMDRIA Approved Consultant (EAC) and Advanced Credit Provider</li>
  <li>EMDR 1 and EMDR 2 EMDR 3, Parnell Institute for EMDR, New York</li>
  <li>LENS Neurofeedback Certified, California</li>
  <li>Gottman Method Couples Therapy – Level 1 and 2, The Gottman Institute</li>
</ul>


<h4 class="skyblue mt-5">Specialized Certifications</h4>
<ul>
  <li>Trauma-Informed Care Specialist</li>
  <li>Leadership, Advocacy and Education</li>
  <li>Specializing in – PTSD, somatic trauma, relationships, couples & family, addiction-related, and mindfulness therapies</li>
  <li>Telehealth Services, <strong>Mental Health Documentation & Medical Necessity</strong> – Clear guidelines for maintaining quality care and practice protection</li>
  <li><strong>Domestic & Intimate Partner Violence</strong> – Identification, documentation, reporting, and trauma-informed responses</li>
  <li><strong>DSM-5-TR™ Mastering Differential Diagnosis</strong> – Symptom-based diagnostic approach</li>
  <li><strong>Suicidal Ideation & Behavior Treatments</strong> – DBT, CT-SP, BCBT-SP, CAMS</li>
</ul>
<h4 class="skyblue mt-5">Certifications in Therapeutic Modalities and Approaches</h4>
<ul>
  <li><strong>Human Services Management Certificate</strong> – evidence-based leadership approaches, community support, client-care, financial oversight, and sustainable growth</li>
  <li><strong>Several EMDR Therapy trainings</strong> – EMDRIA Approved Consultant & Certified EMDR Therapist</li>
  <li><strong>Evidence-Based Approaches</strong> – Intensive and advanced training in:
  <ul class="type-circle mt-4">
    <li>Acceptance and Commitment Therapy (ACT)</li>
    <li>Animal-Assisted Therapy (AAT)</li>
    <li>Bowen Family Systems Theory (BFST)</li>
    <li>Cognitive Behavioral Family Therapy (CBFT) </li>
    <li>Cognitive Behavioral Therapy (CBT)</li>
    <li>Compassion-Focused Therapy (CFT)</li>
    <li>Culturally Sensitive Therapy (CST)</li>
    <li>Dialectical Behavior Therapy (DBT)</li>
    <li>Emotionally Focused Couples Therapy (EFCT)</li>
    <li>Emotionally Focused Family Therapy (EFFT)</li>
    <li>Grief Counseling</li>
    <li>Internal Family Systems (IFS)</li>
    <li>Mindfulness-Based Cognitive Therapy (MBCT) </li>
    <li>Motivational Interviewing</li>
    <li>Person-Centered Therapy (PCT)</li>
    <li>Problem-Solving Skills (PSS)</li>
    <li>Sandtray Therapy</li>
    <li>Solution-Focused Brief Therapy (SFBT)</li>
    <li>Structural Family Therapy</li>
    <li>Supportive Therapy</li>
    <li>Surf Therapy</li>
    <li>Trauma-Focused Cognitive Behavioral Therapy (TF-CBT)</li>
  </ul>
  </li>
</ul>
<h4 class="skyblue mt-5">Additional Training and Certifications</h4> 
<ul>
  <li><strong>Youth Suicide Intervention</strong> – Assessing and addressing suicidal ideation, intent, and behaviors in youth</li>
  <li><strong>Non-Medication Interventions for Sleep and Mental Health</strong> – Restoring sleep quality and improving outcomes</li>
  <li><strong>ADHD Interventions</strong> – Approaches beyond medication</li>
  <li><strong>Reducing Client Dropout</strong> – Strategies for client engagement</li>
  <li><strong>Suicide Assessment & Intervention</strong> – Confident and sensitive crisis intervention</li>
  <li><strong>Ethics of Digital Practice</strong> – Navigating ethical and legal considerations in online services</li>
  <li><strong>Fostering Hope in Suicidal Clients</strong> – Techniques for building resilience and hope</li>
  <li><strong>Psychopharmacology of Trauma</strong> – For prescribers and healthcare professionals</li>
</ul>
 
<h4 class="skyblue mt-5">Professional Affiliations</h4> 
<p>Dr. Linda Timme is affiliated with leading mental health and therapy organizations. These affiliations highlight her dedication to professional excellence, evidence-based practices, and accessible, high-quality care.</p>
<ul>
  <li>Psychology Today – Listed as a verified mental health professional.</li>
  <li>EMDRIA (EMDR International Association) – Recognized as a Certified EMDR Therapist and EMDRIA-Approved Consultant.</li>
  <li>Grow Therapy – Provides accessible mental health services through this trusted platform.</li>
  
</ul>
 <br>
 <br>
 <br>
 <br>
            </div>
          </div>
         </div>
          </section>
    <script>
       /*Paginaton*/
      const cards = document.querySelectorAll(".btn-container > card");
      const $content = document.querySelectorAll(".content");

      cards.forEach((card, key) => {
        card.addEventListener(
          "click",
          function () {
            tabId = card.dataset.id;
            console.log(tabId);

            $content.forEach((cont) => {
              cont.classList.remove("active");
              if (cont.id == tabId) {
                cont.classList.add("active");
              }
            });

            cards.forEach((tab) => {
              tab.classList.remove("active");
              if (tab.dataset.id == tabId) {
                tab.classList.add("active");
              }
            });
          },
          false
        );
      });
      </script>
<?php include('footer.php');?>