<?php include('header.php');?>
<link rel="stylesheet" href="./css/lens.css?v=112" />
    <section class="ochs-labs">
      <div class="container">
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <img src="./images/lens-image-1-border.png" class="img-fluid" alt="" />
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <h2>What are <span>Ochs Labs</span></h2>
            <h3>and LENS Neurofeedback</h3>
            <p>
              Ochs Labs is a leading software development
              company specializing in the
              Low Energy Neurofeedback System (LENS)
              technology, which is utilized in over
              44 countries worldwide. LENS is
              an FDA-approved EEG biofeedback tool designed to
              self-regulate brainwaves, improving cognitive function, emotional
              stability, and physical health. LENS uses advanced software and
              EEG technology to measure brainwave activity at specific sites on
              the head or body. The system utilizes feedback, which helps rewire
              maladaptive patterns in the brain and central nervous system.
            </p>
          </div>
        </div>
        <div class="row mt-5">
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <p>
              <strong>The Neurofeedback:</strong> LENS evaluation comprehensively analyzes your
              brain wave patterns </strong>—Alpha, Theta, Delta, and Beta—</strong> offering
              valuable insights into how these patterns may influence your
              psychological well-being. This innovative approach promotes the
              overall well-being of both mind and body.
            </p>
            <p>
              LENS suits people of all ages and can address various LENS suits
              people of all ages and can address various presenting issues.
              Research has shown that 77% of individuals who underwent
              Neurofeedback for substance dependency were sober after one year,
              compared to only 44% in the control group. Sessions typically last
              <strong>30</strong> minutes, with an average course of treatment consisting of 9 to
              11 sessions
            </p>
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-6">
            <img src="./images/lens-image-2.png" class="img-fluid" alt="" />
          </div>
        </div>
      </div>
    </section>
    <section class="expect">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <h2 class="title">What to Expect ?</h2>
            <div class="description">

              <div class="item mb-5">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>LENS for the brain</h3>
                      <hr />
                      <p>
                        <strong>LENS Neurofeedback</strong> targets the traditional <strong>10-20</strong> universal brain map sites; sensors are placed on the head, measuring and recording electrical signals from the scalp. Advanced software tracks brainwaves in real-time, allowing the brain to reset its neural connectivity and optimize<span class="points-read-more">...</span> <a href="javascript:void(0);" class="btn-read-more">Read more</a> <span class="text-read-more d-none"> its overall function, including that of the <strong>central nervous system (CNS)</strong>. Increasing blood flow, oxygen, and nutrients to suppressed areas reduces maladaptive patterns and balances neurochemistry, allowing the brain to reorganize and adopt healthier patterns.</span> 
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/lens-for-the-brain.jpg"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>
 
              <div class="item mb-5">
                <div class="row">
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <div class="text">
                      <h3>LENS for the body</h3>
                      <hr />
                      <p>
                        <strong>Body LENS Therapy</strong> is an advanced neurofeedback technique that extends the principles of <strong>Low Energy Neurofeedback System (LENS)</strong> to target the body’s peripheral nervous system. This therapy aims to <strong>reset and balance</strong> the nervous system, promoting well-being and reducing physical and emotional symptoms. 
                      </p>
                    </div>
                  </div>
                  <div class="col-12 col-sm-12 col-md-12 col-lg-6">
                    <img
                      src="./images/lens-for-the-body.jpg"
                      class="img-fluid"
                      alt
                    />
                  </div>
                </div>
              </div>

            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="balanced">
      <div class="container">
        <div class="row">
          <div class="col-12">
            <h2 class="title">“A BALANCED BRAIN = A BALANCED LIFE"</h2>
            <h3 class="my-4 text-center">LENS Neurofeedback: Symptoms</h3>
            <hr>
            <p class="my-5 text-center">LENS leverages natural neuroplasticity and self-regulation<br>
to address diverse symptoms such as</p>
          </div>
        </div>
        <div class="row">
          <div class="col-12 col-sm-12 col-md-12 col-lg-6 mb-5">
            <card>
              <h3>Mental Health</h3>
              <hr>
              <ul>
                <li>Addiction/Dependencies Recovery</li>
                <li>Anger and Rage Management</li>
                <li>Anxiety/Panic Attacks</li>
                <li>Bipolar Disorder</li>
                <li>Depression</li>
              </ul>
            </card> 
          </div>
          <div class="col-12 col-sm-12 col-md-12 col-lg-6 mb-5">
            <card>
              <h3>Trauma Recovery</h3>
              <hr>
              <ul>
                <li>Anoxia</li>
                <li>Chemo Brain</li>
                <li>Post-Concussion Syndrome</li>
                <li>Post-Traumatic Stress Disorder (PTSD)</li>
                <li>Seizures</li>
                <li>Stroke Recovery</li>
                <li>Traumatic Brain Injury (TBI)</li>
                <li>Vertigo</li>
                
              </ul>
            </card>
          </div>
        </div>
        
      </div>
    </section>
    <section class="testimonial">
      <div class="container">
        <div class="row"> 
          <div class="col-12">
            <p class="py-4 text-center">
            “Mental Health is no longer in charge.”<br>
Client testimonial, 2023 
</p>
          </div>
        </div>
        <div class="row">
          <div class="col-12 block-cards">
            <card>
              <img src="./images/testimonial-image-1.jpg" />
              <div class="text">
                <h3>Developmental Disorder</h3>
                <ul>
                  <li>Autism Spectrum Disorder (ASD)</li>
                  <li>Pervasive Developmental Disorder-Not Otherwise Specified (PDD-NOS)</li>
                  <li>Reactive Attachment Disorder (RAD)</li>
                  <li>Sensory Processing Disorder</li>
                </ul>
                <p>
                  “My daughter used to struggle with daily tasks. Now, her social skills and confidence have improved.”— Parent of a 10-year-old child, 2024
                </p>
              </div>
            </card>
            <card>
              <img src="./images/testimonial-image-2.jpg" />
              <div class="text">
                <h3>Academic Achievement</h3>
                <ul>
                  <li>Academic Anxiety</li>
                  <li>Attention Deficit Disorder (ADD) / Attention-Deficit/Hyperactivity Disorder (ADHD)</li>
                  <li>Learning Disabilities</li>
                  <li>Memory Issues</li>
                </ul>
                <p>
                  “My daughter’s grades are good, and she is even enjoying her classes.”— Parent of an 18-year-old, 2024
                </p>
              </div>
            </card>
            <card>
              <img src="./images/testimonial-image-3.jpg" />
              <div class="text">
                <h3>Aging and Memory</h3>
                <ul>
                  <li>Alzheimer’s Disease</li>
                  <li>Attention and Focus in Aging</li>
                  <li>Dementia</li>
                  <li>Memory Improvement</li>
                  
                </ul>
                <p>
                  “My mom is engaged, and her memory is better than it’s been in years.”— Daughter testimonial, 2023
                </p>
              </div>
            </card>
            <card>
              <img src="./images/testimonial-image-4.jpg" />
              <div class="text">
                <h3>Chronic Health Issues</h3>
                <ul>
                  <li>Chronic Fatigue Syndrome (CFS)</li>
                  <li>Chronic Pain</li>
                  <li>Fibromyalgia</li>
                  <li>Lyme Disease</li>
                  <li>Migraine</li>
                  <li>Multiple Chemical Sensitivity (MCS)</li>
                  <li>Multiple Sclerosis (MS)</li>
                  <li>Parkinson’s Disease</li>
                  <li>Temporomandibular Joint Disorder (TMJ)</li>
                  
                </ul>
                <p>
                  “I was trapped in my own body with pain and fatigue. Now, I am feeling energized and face the day.”— Client testimonial, 2024
                </p>
              </div>
            </card>
            <card>
              <img src="./images/testimonial-image-5.jpg" />
              <div class="text">
                <h3>Peak Performance</h3>
                <ul>
                  <li>Achievement Enhancement</li>
                  <li>Athletic Performance</li>
                  <li>Attention and Focus Improvement</li>
                  <li>Concentration</li>
                  <li>Motivation Boosting</li>
                </ul>
                <p>
                  “My motivation and concentration have increased significantly.”— Client testimonial, 2023
                </p>
              </div>
            </card>
          </div>
        </div>
      </div>
    </section>
    
    <section class="steps testimonial">
      <div class="container">
        <div class="row">
          <h2 class="title mx-auto">Steps for Head LENS and Body LENS session</h2>
          <h4 class="mx-auto mb-5">Over 85% of individuals receiving LENS Neurotherapy have experienced<br>
signiﬁcant, lasting beneﬁts, often noticeable within the ﬁrst 1-2 sessions.</h4>
        </div>  
        <div class="row">
          <div class="col-12 block-cards">
            <card>
              <div class="text">
                <h3>1. Preparation: </h3>
                <p>Sensors are placed on the
forehead or scalp after the skin
is cleaned with mild gel. For
Body LENS, sensors are placed
on areas like the spine or
ﬁngers, targeting are of pain or
dysfunction point</p>
              </div>
            </card>
            <card>
              <div class="text">
                <h3>
                  2. Non-Invasive 
Process:
                </h3>
                <p>LENS is entirely noninvasive. It
uses sensors to measure
electrical signals</p>
              </div>
            </card>
            <card>
              <div class="text">
                <h3>3. Session
Protocol:</h3>
<p>During sessions, you’ll sit
quietly with eyes closed. You
won’t see or feel the feedback,
but your body will respond to
the signals picked up by the
sensors.</p>
                
              </div>
            </card>
            <card>
              <div class="text">
                <h3>4. Passive
Participation</h3>
<p>Relax with your eyes closed; no
focus or speciﬁc skills are
required. You’ll occasionally be
asked about sensations to
ﬁne-tune the feedback</p>
              </div>
            </card>
            <card>
              <div class="text">
                <h3>5. Symptom
Tracking:</h3>
<p>A brief questionnaire should be
completed before and 48 hours
after each session to monitor
progress and adjust therapy as
needed</p>
              </div>
            </card>
          </div>
        </div>
</div>
</section>

<section class="session">
  <div class="container">
    <div class="row mb-5">
      <div class="col-12 col-sm-12 col-md-12 col-lg-6">
           <img src="./images/lens-session-duration-1.jpg" class="img-fluid" alt="" />
      </div>
      <div class="col-12 col-sm-12 col-md-12 col-lg-6">
        <h2 class="title">Session Duration
and Frequency</h2>
<p>The duration of each session can range from a few
seconds to a few minutes, and the number of sessions
needed depends on your speciﬁc needs:</p>
<ul>
  <lI>4-10 sessions: Generally suitable for sudden-onset
issues, non-include severe TB</lI>
  <lI>Around 20 sessions: Recommended for SUITABLE
complex problems</lI>
  <lI>40+ sessions: maybe need more sessions for stroke or
head injury</lI>
</ul>
      </div>
    </div>

    <div class="row block-change-order">
        <div class="col-12 col-sm-12 col-md-12 col-lg-6 change-order-one">
          <h2 class="title">Fees for Head and Body
LENS (Virtual or In-Person)</h2>
            <ul>
              <li><strong>Initial Assessment and Treatment Consultation:</strong> $175
for a 55-minute session</li>
              <li><strong>Body LENS:</strong> $125 per session</li>
              <li><strong>Head LENS, Single Session:</strong> $125 per session</li>
              <li><strong>Head LENS Packages:</strong>
                <ul>
                  <li>Five-Session Package: $550</li>
                  <li>Ten-Session Package: $1000</li>
                  <li>Family Package: $1,200 (15 sessions for a family of 4)</li>
                </ul>
              </li>
              
            </ul>
            <p>The 10-session package can be used by 1 client or
shared between 3 family members</p>
        </div>
        <div class="col-12 col-sm-12 col-md-12 col-lg-6 change-order-two">
          <img src="./images/lens-session-duration-2.jpg" class="img-fluid" alt="" />
        </div>
    </div>

    <div class="row my-5">
    <div class="col-12">
      <h5 class="text-center">Please note that Neuro-biofeedback is largely not covered by traditional insurance. <br>Payment is expected at the time of service. Confirm biofeedback reimbursement with your HSA, FSA, or insurance provider.</h5>
    </div>
    </div>

  </div>
</section>
<section class="reserva-lens">
  <div class="container">
 
  </div>
</section>
<?php include('_request-an-appointment.php');?>
<?php include('footer.php');?>